# Wine

Wine can refer to an alcoholic drink made out of grape juice or a computer program that is a windows compatibility layer to make it so windows programs run on a Unix system without the need of a dualboot setup or use of virtual machines. With the latter, you can think of wine as a replacement and reimplimentation of the Win32 api since that is what wine replicates. The acronym for wine stands for wine is not an emulator. Wine has less overhead compared to more traditional emulators like rpcs3 and sometimes running windows programs and games through wine can result in better performance than running them on Windows. When running windows programs through wine, they make use of unix drivers rather than windows ones. For example when running a game through wine with an amd gpu, it will make use of the mesa driver instead of the amd windows amd adrenaline driver.

Proton Section

Proton is a compatibility layer made by Valve and is a fork of wine. It also makes use of [dxvk](dxvk.md) and [vkd3d](vkd3d) (can be used in normal wine) which translates direct x to vulkan since Unix systems do not have support for direct x since the api is proprietary to [Microsoft](microsoft.md). It has changed the landscape of [GNU](gnu.md)/[Linux](linux.md) gaming. Before proton, it would be rare for AAA or even indie games to be playable on GNU/Linux. There are forks of proton such as proton ge that include more improvements to proton, includes codecs for fmvs, and is based on more bleeding edge versions of wine. The most user friendly way to use proton is with [steam](steam.md) but you can use it without Steam such as with games not distributed on Steam, drm free games from both steam or gog, or cracked versions of games. It is nice being able to use proton outside of steam since it is a [proprietary](proprietary.md) service and relies on having an online steam account. According to their TOS, they can take away your account or games licensed under your account at any time and you cannot share or pass down your steam account to friends or family,
 
The most user friendly way to use proton outside steam is with GUI launchers such as Lutris and Heroic games launcher
On arch based distros this is how you install either program
```
sudo pacman -S lutris
paru heroic-games-launcher-bin
```

cachyos heroic install
```
sudo pacman -S heroic-games-launcher-bin
```

For the version of wine, make sure Proton ge is selected and click plus icon to add game

You can use umu-launcher as a non gui way of using proton outside steam and can put a shell script next to the game's executable so you do not need to memorize proton commands every time you want to launch a game. I prefer this method since it is more minimalistic and I do not have to deal with a GUI launcher.

Installation of umu on arch based distros
```
sudo pacman -S umu-launcher
```

create shell script of game executable (game should be replaced with exe file name)
```
touch game.sh
```

make script executable
```
chmod +x game.sh
```

use a text editor such as kate, gedit, vim, emacs, or nano to edit script I will use vim as an example but kate or gedit would be easier to use
```
vim game.sh
```

text to put into script 
```
#! /bin/sh
WINEPREFIX=/PATH/TO/WINEPREFIX PROTONPATH=GE-Proton umu-run ./"game.exe"
```

If you want to put a proton command put it in between protonpath and umu run. /PATH/TO/WINEPREFIX will be replaced with where you would want wineprefix to be 
```
#! /bin/sh
WINEPREFIX=/home/$(whoami)/umu/umu-default PROTONPATH=GE-Proton PROTON_PREFER_SDL=1 mangohud umu-run ./"game.exe"
```

You can now double click the shell script or execute it from terminal and type
```
./game.sh
```
Now proton works without Steam or GUI launcher such as heroic or lutris

## [See also]
- [emulator](emulator.md)
- [virtual machine](vm.md)
- [windows](windows.md)
